/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.ArrayNodeDiff;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.ColumnController;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.autoplot.dom.RowController;
import org.autoplot.layout.LayoutConstants;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Painter;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.util.LoggerManager;

public class CanvasController
extends DomNodeController {
    protected static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.canvas");
    protected static final Logger resizeLogger = LoggerManager.getLogger((String)"autoplot.dom.canvas.resize");
    DasCanvas dasCanvas;
    private final Application dom;
    private final Canvas canvas;
    private final Timer repaintSoonTimer;
    private final Timer setSizeTimer;
    DropTargetListener dropTargetListener;
    private List<DomNode> currentSelectionItems;
    private long currentSelectionBirthtime = 0L;

    public CanvasController(Application dom, Canvas canvas) {
        super(canvas);
        this.dom = dom;
        this.canvas = canvas;
        canvas.controller = this;
        this.repaintSoonTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CanvasController.this.dasCanvas.repaint();
            }
        });
        this.repaintSoonTimer.setRepeats(false);
        this.setSizeTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CanvasController.this.setDasCanvasSize();
            }
        });
        this.setSizeTimer.setRepeats(false);
    }

    public void setColumn(String column) {
        String[] ss = column.split(",");
        this.canvas.getMarginColumn().setLeft(ss[0]);
        this.canvas.getMarginColumn().setRight(ss[1]);
        this.canvas.getMarginColumn().setLeft(ss[0]);
    }

    public void setRow(String row) {
        String[] ss = row.split(",");
        this.canvas.getMarginRow().setTop(ss[0]);
        this.canvas.getMarginRow().setBottom(ss[1]);
        this.canvas.getMarginRow().setTop(ss[0]);
    }

    private void setDasCanvasSize() {
        int w = Math.min(4000, this.canvas.getWidth());
        int h = Math.min(4000, this.canvas.getHeight());
        Dimension d = new Dimension(w, h);
        resizeLogger.log(Level.FINER, "setDasCanvasSize {0}", d);
        this.dasCanvas.setPreferredSize(d);
        this.dasCanvas.setSize(d);
    }

    public void setDimensions(int width, int height) {
        resizeLogger.log(Level.FINE, "setDimensions({0,number,#},{1,number,#})", new Object[]{width, height});
        int oldWidth = this.canvas.width;
        int oldHeight = this.canvas.height;
        this.canvas.width = width;
        this.canvas.height = height;
        if (oldWidth != width) {
            this.canvas.propertyChangeSupport.firePropertyChange("width", oldWidth, width);
        }
        if (oldHeight != height) {
            this.canvas.propertyChangeSupport.firePropertyChange("height", oldHeight, height);
        }
    }

    protected void setDasCanvas(DasCanvas canvas) {
        assert (this.dasCanvas != null);
        this.dasCanvas = canvas;
        ApplicationController ac = this.dom.controller;
        this.dasCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CanvasController.this.dom.getController().setPlotElement(null);
                CanvasController.this.dom.getController().setStatus("ready");
            }
        });
        this.dasCanvas.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (CanvasController.this.dom.getController().isValueAdjusting()) {
                    resizeLogger.fine("no already adjusting, ignoring");
                    return;
                }
                if (CanvasController.this.setSizeTimer.isRunning()) {
                    resizeLogger.fine("setSizeTimer is running, ignoring");
                    return;
                }
                int w = CanvasController.this.dasCanvas.getWidth();
                int h = CanvasController.this.dasCanvas.getHeight();
                logger.log(Level.FINER, "got componentResize {0}x{1}", new Object[]{w, h});
                CanvasController.this.setDimensions(w, h);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.canvas.addPropertyChangeListener("width", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                CanvasController.this.setSizeTimer.restart();
                if (((CanvasController)CanvasController.this).dom.controller.model.isHeadless()) {
                    CanvasController.this.setDasCanvasSize();
                }
            }
        });
        this.canvas.addPropertyChangeListener("height", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                CanvasController.this.setSizeTimer.restart();
                if (((CanvasController)CanvasController.this).dom.controller.model.isHeadless()) {
                    CanvasController.this.setDasCanvasSize();
                }
            }
        });
        ac.bind(this.canvas, "fitted", this.dasCanvas, "fitted");
        ac.bind(this.canvas, "font", this.dasCanvas, "baseFont", DomUtil.STRING_TO_FONT);
    }

    public DasCanvas getDasCanvas() {
        return this.dasCanvas;
    }

    public DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    public void setDropTargetListener(DropTargetListener list) {
        DropTargetListener old = this.dropTargetListener;
        this.dropTargetListener = list;
        this.propertyChangeSupport.firePropertyChange("dropTargetListener", old, list);
    }

    Column getColumn(Column r, Object dir) {
        int idx = this.canvas.columns.indexOf(r);
        if (idx == -1) {
            throw new IllegalArgumentException("canvas doesn't contain this column");
        }
        if (dir == LayoutConstants.LEFT) {
            if (idx == 0) {
                return null;
            }
            return this.canvas.columns.get(idx - 1);
        }
        if (dir == LayoutConstants.RIGHT) {
            if (idx == this.canvas.columns.size() - 1) {
                return null;
            }
            return this.canvas.columns.get(idx + 1);
        }
        throw new IllegalArgumentException("dir must be LEFT or RIGHT");
    }

    Row getRow(Row r, Object dir) {
        int idx = this.canvas.rows.indexOf(r);
        if (idx == -1) {
            throw new IllegalArgumentException("canvas doesn't contain this row");
        }
        if (dir == LayoutConstants.ABOVE) {
            if (idx == 0) {
                return null;
            }
            return this.canvas.rows.get(idx - 1);
        }
        if (dir == LayoutConstants.BELOW) {
            if (idx == this.canvas.rows.size() - 1) {
                return null;
            }
            return this.canvas.rows.get(idx + 1);
        }
        throw new IllegalArgumentException("dir must be ABOVE or BELOW");
    }

    public Row getRowFor(Plot domPlot) {
        if (domPlot.getRowId().equals(this.canvas.marginRow.getId())) {
            return this.canvas.marginRow;
        }
        for (Row row : this.canvas.getRows()) {
            if (!row.getId().equals(domPlot.getRowId())) continue;
            return row;
        }
        throw new IllegalArgumentException("no row found for " + domPlot);
    }

    Row getRowFor(DasRow dasRow) {
        for (Row row : this.canvas.getRows()) {
            if (row.controller.getDasRow() != dasRow) continue;
            return row;
        }
        throw new IllegalArgumentException("no dom row found for " + dasRow);
    }

    Column getColumnFor(Plot domPlot) {
        if (domPlot.getColumnId().equals(this.canvas.marginColumn.getId())) {
            return this.canvas.marginColumn;
        }
        for (Column column : this.canvas.getColumns()) {
            if (!column.getId().equals(domPlot.getColumnId())) continue;
            return column;
        }
        throw new IllegalArgumentException("no column found for " + domPlot);
    }

    private static void resetToFollow(List<Row> rows, String overlap, Row row) {
        String[] overlaps = overlap.split(" ");
        double min = 1.0;
        double max = 0.0;
        for (String overlap1 : overlaps) {
            for (Row row1 : rows) {
                if (!row1.getId().equals(overlap1)) continue;
                if (row1.getController().getDasRow().getMinimum() < min) {
                    min = row1.getController().getDasRow().getMinimum();
                }
                if (!(row1.getController().getDasRow().getMaximum() > max)) continue;
                max = row1.getController().getDasRow().getMaximum();
            }
        }
        row.getController().dasRow.setMinimum(min);
        row.getController().dasRow.setMaximum(max);
    }

    public static void removeGapsAndOverlaps(Application dom, List<Row> rows, Row newRow, boolean preserveOverlaps) {
        int i;
        if (rows.isEmpty()) {
            return;
        }
        int[] weights = new int[rows.size()];
        int totalWeight = 0;
        String[] overlaps = new String[rows.size()];
        double[] mins = new double[rows.size()];
        double[] maxs = new double[rows.size()];
        int[] count = new int[rows.size()];
        for (i = 0; i < rows.size(); ++i) {
            try {
                double nmin = DasDevicePosition.parseLayoutStr((String)rows.get(i).getTop())[0];
                double nmax = DasDevicePosition.parseLayoutStr((String)rows.get(i).getBottom())[0];
                if (rows.get((int)i).getController().dasRow.getParent().getHeight() < 10) {
                    dom.controller.getDasCanvas().setSize(dom.getCanvases(0).getWidth(), dom.getCanvases(0).getHeight());
                    dom.controller.getDasCanvas().setFont(Font.decode(dom.getOptions().getCanvasFont()));
                    logger.log(Level.FINEST, "height<10 branch, now {0}", rows.get((int)i).getController().dasRow.getParent().getHeight());
                }
                mins[i] = rows.get((int)i).getController().dasRow.getDMinimum();
                maxs[i] = rows.get((int)i).getController().dasRow.getDMaximum();
                weights[i] = (int)Math.round((nmax - nmin) * 1000.0);
            }
            catch (ParseException ex) {
                weights[i] = 200;
            }
            totalWeight += weights[i];
        }
        if (preserveOverlaps) {
            for (i = 0; i < rows.size(); ++i) {
                for (int j = 0; j < rows.size(); ++j) {
                    if (i == j || rows.get(i) == newRow || rows.get(j) == newRow || !(maxs[i] > mins[j]) || !(mins[i] < maxs[j])) continue;
                    int n = i;
                    count[n] = count[n] + 1;
                    overlaps[i] = overlaps[i] == null ? rows.get((int)j).id : overlaps[i] + " " + rows.get((int)j).id;
                }
            }
        }
        for (i = 0; i < rows.size(); ++i) {
            if (count[i] <= 1) continue;
            totalWeight -= weights[i];
            weights[i] = 0;
        }
        if (totalWeight == 0) {
            weights[0] = 100;
            totalWeight = 100;
        }
        for (i = 0; i < rows.size(); ++i) {
            if (totalWeight == 0) {
                logger.severe("here total weights are zero");
            }
            weights[i] = 1000 * weights[i] / totalWeight;
        }
        totalWeight = 1000;
        int t = 0;
        for (int idx = 0; idx < weights.length; ++idx) {
            DasRow dasRow = rows.get((int)idx).controller.getDasRow();
            dasRow.setMinimum(1.0 * (double)t / (double)totalWeight);
            dasRow.setMaximum(1.0 * (double)(t + weights[idx]) / (double)totalWeight);
            t += weights[idx];
        }
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            if (count[i2] <= 1) continue;
            CanvasController.resetToFollow(rows, overlaps[i2], rows.get(i2));
        }
    }

    static void removeGapsAndOverlapsInColumns(List<Column> columns) {
        int i;
        if (columns.isEmpty()) {
            return;
        }
        int[] weights = new int[columns.size()];
        int totalWeight = 0;
        for (i = 0; i < columns.size(); ++i) {
            try {
                double nmin = DasDevicePosition.parseLayoutStr((String)columns.get(i).getRight())[0];
                double nmax = DasDevicePosition.parseLayoutStr((String)columns.get(i).getLeft())[0];
                weights[i] = (int)Math.round((nmax - nmin) * 1000.0);
            }
            catch (ParseException ex) {
                weights[i] = 200;
            }
            totalWeight += weights[i];
        }
        for (i = 0; i < columns.size(); ++i) {
            weights[i] = 1000 * weights[i] / totalWeight;
        }
        totalWeight = 1000;
        int t = 0;
        double emIn = columns.size() < 2 ? 0.0 : 2.0;
        for (int idx = 0; idx < weights.length; ++idx) {
            DasColumn dasColumn = columns.get((int)idx).controller.getDasColumn();
            dasColumn.setMinimum(1.0 * (double)t / (double)totalWeight);
            dasColumn.setMaximum(1.0 * (double)(t + weights[idx]) / (double)totalWeight);
            t += weights[idx];
            dasColumn.setEmMinimum(emIn);
            dasColumn.setEmMaximum(-emIn);
        }
    }

    private List<Row> getRowsWithMarginParent() {
        ArrayList<Row> result = new ArrayList<Row>(this.canvas.getRows().length);
        for (Row r : this.canvas.getRows()) {
            if (!r.getParent().equals(this.canvas.getMarginRow().getId())) continue;
            result.add(r);
        }
        return result;
    }

    void removeGaps() {
        CanvasController.removeGapsAndOverlaps(this.dom, this.getRowsWithMarginParent(), null, true);
        this.repaintSoon();
    }

    void repaintSoon() {
        this.repaintSoonTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertGapFor(Row row, Row trow, Object position) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Insert Gap For");
        try {
            List<Row> rows = this.getRowsWithMarginParent();
            int ipos = position == LayoutConstants.BELOW ? rows.indexOf(trow) + 1 : rows.indexOf(trow);
            rows.add(ipos, row);
            row.syncTo(trow, Arrays.asList("id"));
            List<Diff> d = DomUtil.getDiffs(row, trow, Arrays.asList("id"));
            if (d.size() > 0) {
                row.syncTo(trow, Arrays.asList("id"));
            }
            CanvasController.removeGapsAndOverlaps(this.dom, rows, row, true);
        }
        finally {
            lock.unlock();
        }
        this.repaintSoon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertGapFor(Column column, Column tcolumn, Object position) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Insert Gap For");
        try {
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            int ipos = position == LayoutConstants.BELOW ? columns.indexOf(tcolumn) + 1 : columns.indexOf(tcolumn);
            columns.add(ipos, column);
            column.syncTo(tcolumn, Arrays.asList("id"));
            List<Diff> d = DomUtil.getDiffs(column, tcolumn, Arrays.asList("id"));
            if (d.size() > 0) {
                column.syncTo(tcolumn, Arrays.asList("id"));
            }
            CanvasController.removeGapsAndOverlapsInColumns(columns);
        }
        finally {
            lock.unlock();
        }
        this.repaintSoon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row addInsertRow(Row trow, Object position) {
        Row row = new Row();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Insert Row");
        try {
            row.setParent(this.canvas.getMarginRow().getId());
            new RowController(this.dom.controller, row).createDasPeer(this.canvas, this.canvas.getMarginRow().getController().getDasRow());
            this.dom.getController().assignId(row);
            if (trow != null && (position == LayoutConstants.ABOVE || position == LayoutConstants.BELOW)) {
                this.insertGapFor(row, trow, position);
            }
            ArrayList<Row> rows = new ArrayList<Row>(Arrays.asList(this.canvas.getRows()));
            int ipos = rows.size();
            if (trow != null) {
                ipos = position == LayoutConstants.BELOW ? rows.indexOf(trow) + 1 : rows.indexOf(trow);
            }
            rows.add(ipos, row);
            this.canvas.setRows(rows.toArray(new Row[rows.size()]));
            this.dom.getController().assignId(row);
        }
        finally {
            lock.unlock();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Column addInsertColumn(Column tcolumn, Object position) {
        Column column = new Column();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Insert Column");
        try {
            column.setParent(this.canvas.getMarginColumn().getId());
            new ColumnController(this.dom.controller, column).createDasPeer(this.canvas, this.canvas.getMarginColumn().getController().getDasColumn());
            if (tcolumn != null) {
                this.insertGapFor(column, tcolumn, position);
            }
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            int ipos = columns.size();
            if (tcolumn != null) {
                ipos = position == LayoutConstants.RIGHT ? columns.indexOf(tcolumn) + 1 : columns.indexOf(tcolumn);
            }
            columns.add(ipos, column);
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
            this.dom.getController().assignId(column);
        }
        finally {
            lock.unlock();
        }
        return column;
    }

    public List<Row> addRows(int count) {
        return this.addRows(count, LayoutConstants.BELOW);
    }

    public List<Row> addRows(int count, Object dir) {
        Row trow = this.dom.getController().getPlot() != null ? this.getRowFor(this.dom.getController().getPlot()) : this.canvas.getRows(this.canvas.getRows().length - 1);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < count; ++i) {
            Row newRow = this.addInsertRow(trow, dir);
            rows.add(newRow);
            trow = newRow;
        }
        return rows;
    }

    private List<Column> findColumnSet(int count) {
        Column[] cc = this.canvas.getColumns();
        if (cc.length == count) {
            double[] mins = new double[count];
            double[] maxs = new double[count];
            for (int i = 0; i < cc.length; ++i) {
                mins[i] = cc[i].getController().dasColumn.getDMinimum();
                maxs[i] = cc[i].getController().dasColumn.getDMaximum();
                if (i <= 0 || !(mins[i] < maxs[i - 1])) continue;
                return null;
            }
            return Arrays.asList(cc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Column> addColumns(int count) {
        if (count < 2) {
            throw new IllegalArgumentException("count must be greater than 1");
        }
        List<Column> result = this.findColumnSet(count);
        if (result != null) {
            return result;
        }
        result = new ArrayList<Column>();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Columns");
        try {
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            for (int i = 0; i < count; ++i) {
                Column column = new Column();
                column.setParent(this.canvas.getMarginColumn().getId());
                new ColumnController(this.dom.controller, column).createDasPeer(this.canvas, this.canvas.getMarginColumn().getController().getDasColumn());
                this.dom.getController().assignId(column);
                result.add(column);
                int lpm = 1000 * i / count;
                int rpm = 1000 * (i + 1) / count;
                int lem = i * 50 / (count - 1);
                int rem = 50 * (count - 1 - i) / (count - 1);
                column.setLeft("" + (double)lpm / 10.0 + "%+" + (double)lem / 10.0 + "em");
                column.setRight("" + (double)rpm / 10.0 + "%-" + (double)rem / 10.0 + "em");
            }
            columns.addAll(result);
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public Column addColumn() {
        return this.addInsertColumn(null, null);
    }

    public Row addRow() {
        return this.addInsertRow(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRow(Row row) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Row");
        try {
            ArrayList<Row> rows = new ArrayList<Row>(Arrays.asList(this.canvas.getRows()));
            rows.remove(row);
            row.getController().getDasRow().removeListeners();
            this.canvas.setRows(rows.toArray(new Row[rows.size()]));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteColumn(Column column) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Column");
        try {
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            columns.remove(column);
            column.getController().getDasColumn().removeListeners();
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
        }
        finally {
            lock.unlock();
        }
    }

    protected void syncTo(Canvas canvas, List<String> exclude, Map<String, String> layoutIds) {
        List<Diff> diffs = canvas.diffs(this.canvas);
        for (Diff d : diffs) {
            if (exclude.contains(d.propertyName())) continue;
            try {
                if (d instanceof ArrayNodeDiff) {
                    ArrayNodeDiff arrayNodeDiff = (ArrayNodeDiff)d;
                }
                d.doDiff(this.canvas);
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING, null, ex);
                d.doDiff(this.canvas);
            }
        }
        for (Row row : this.canvas.getRows()) {
            if (row.controller != null) continue;
            new RowController(this.dom.controller, row).createDasPeer(this.canvas, this.canvas.getMarginRow().getController().getDasRow());
        }
        for (DomNode domNode : this.canvas.getColumns()) {
            if (((Column)domNode).controller != null) continue;
            new ColumnController(this.dom.controller, (Column)domNode).createDasPeer(this.canvas, this.canvas.getMarginColumn().getController().getDasColumn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indicateSelection(List<DomNode> selectedItems) {
        if (!this.dasCanvas.isShowing()) {
            return;
        }
        final ArrayList<GeneralPath> sel = new ArrayList<GeneralPath>();
        final ArrayList<Rectangle> clip = new ArrayList<Rectangle>();
        final long t1 = System.currentTimeMillis();
        CanvasController canvasController = this;
        synchronized (canvasController) {
            if (this.currentSelectionItems != null) {
                return;
            }
            this.currentSelectionItems = selectedItems;
            if (t1 - this.currentSelectionBirthtime > 3000L) {
                this.currentSelectionItems = selectedItems;
            }
            this.currentSelectionBirthtime = t1;
        }
        logger.log(Level.FINER, "get highlite area");
        for (Object e : selectedItems) {
            if (e instanceof Plot) {
                DasPlot p = ((Plot)e).getController().getDasPlot();
                GeneralPath result = new GeneralPath();
                GraphUtil.reducePath((PathIterator)SelectionUtil.getSelectionArea((DasCanvasComponent)p).getPathIterator(null), (GeneralPath)result, (int)10);
                sel.add(result);
                clip.add(p.getBounds());
            } else if (e instanceof PlotElement) {
                Renderer rend = ((PlotElement)e).getController().getRenderer();
                if (rend == null) {
                    return;
                }
                DasPlot p = rend.getParent();
                if (p == null) {
                    return;
                }
                Rectangle r = p.getBounds();
                GeneralPath result = new GeneralPath();
                Shape gp = SelectionUtil.getSelectionArea((Renderer)rend);
                if (gp != null) {
                    GraphUtil.reducePath((PathIterator)gp.getPathIterator(null), (GeneralPath)result, (int)10);
                    sel.add(result);
                    clip.add(r);
                } else {
                    logger.warning("reducePath contract broken by renderer that returns null.");
                }
            }
            logger.log(Level.FINER, "got highlite area in {0} millis", System.currentTimeMillis() - t1);
        }
        final Painter p = new Painter(){

            public void paint(Graphics2D g) {
                long t0 = System.currentTimeMillis();
                logger.log(Level.FINER, "enter paint decorator");
                if (CanvasController.this.dasCanvas.lisPaintingForPrint()) {
                    logger.fine("not painting select");
                    return;
                }
                g.setColor(new Color(255, 255, 0, 100));
                Shape clip0 = g.getClip();
                for (int i = 0; i < sel.size(); ++i) {
                    Shape s = (Shape)sel.get(i);
                    Rectangle c = (Rectangle)clip.get(i);
                    if (s != null) {
                        g.clip(c);
                        g.fill(s);
                        g.setClip(clip0);
                        continue;
                    }
                    g.clip(c);
                    Stroke stroke0 = g.getStroke();
                    g.setStroke(new BasicStroke(10.0f));
                    g.draw(c);
                    g.setClip(clip0);
                    g.setStroke(stroke0);
                }
                logger.log(Level.FINER, "paint decorator in {0} ms", System.currentTimeMillis() - t0);
            }
        };
        logger.log(Level.FINER, "set up decorator {0} {1}", new Object[]{p, System.currentTimeMillis() - t1});
        boolean bl = true;
        if (bl) {
            logger.log(Level.FINER, "create decorator {0} {1}", new Object[]{p, System.currentTimeMillis() - t1});
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    logger.log(Level.FINER, "add decorator {0} {1}", new Object[]{p, System.currentTimeMillis() - t1});
                    CanvasController.this.dasCanvas.addTopDecorator(p);
                    Timer clearSelectionTimer = new Timer(300, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            logger.log(Level.FINEST, "rm decorator {0} {1}", new Object[]{p, System.currentTimeMillis() - t1});
                            CanvasController.this.dasCanvas.removeTopDecorator(p);
                            CanvasController.this.currentSelectionItems = null;
                            logger.log(Level.FINER, "done rm decorator {0} {1}", new Object[]{p, System.currentTimeMillis() - t1});
                        }
                    });
                    clearSelectionTimer.setRepeats(false);
                    clearSelectionTimer.restart();
                    logger.log(Level.FINER, "done add decorator {0} {1}", new Object[]{p, System.currentTimeMillis() - t1});
                }
            };
            SwingUtilities.invokeLater(run);
            logger.log(Level.FINER, "highlite selection in {0}ms", System.currentTimeMillis() - t1);
        }
    }

    ApplicationController getApplicationController() {
        return this.dom.getController();
    }

    public String toString() {
        return "" + this.canvas + " controller";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column maybeAddColumn(String spec) {
        String[] ss = spec.split(",");
        if (ss.length != 2) {
            throw new IllegalArgumentException("spec format error, expected comma: " + spec);
        }
        try {
            for (Column c : this.canvas.getColumns()) {
                if (!c.controller.isLayoutEqual(spec)) continue;
                return c;
            }
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        Column column = new Column();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Maybe Add Column");
        try {
            column.setParent("");
            new ColumnController(this.dom.controller, column).createDasPeer(this.canvas, null);
            this.dom.getController().assignId(column);
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            columns.add(column);
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
            this.dom.getController().assignId(column);
            column.setLeft(ss[0]);
            column.setRight(ss[1]);
        }
        finally {
            lock.unlock();
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row maybeAddRow(String spec) {
        String[] ss = spec.split(",");
        if (ss.length != 2) {
            throw new IllegalArgumentException("spec format error, expected comma: " + spec);
        }
        try {
            for (Row r : this.canvas.getRows()) {
                if (!r.controller.isLayoutEqual(spec)) continue;
                return r;
            }
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        Row row = new Row();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Maybe Add Row");
        try {
            row.setParent("");
            new RowController(this.dom.controller, row).createDasPeer(this.canvas, null);
            this.dom.getController().assignId(row);
            ArrayList<Row> rows = new ArrayList<Row>(Arrays.asList(this.canvas.getRows()));
            rows.add(row);
            this.canvas.setRows(rows.toArray(new Row[rows.size()]));
            this.dom.getController().assignId(row);
            row.setTop(ss[0]);
            row.setBottom(ss[1]);
        }
        finally {
            lock.unlock();
        }
        return row;
    }
}

